<?php

    /**
    *
    * copyright (c) 2015-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    */

    class GestoreFile {
        private $percorso;
        private $contenuto;
        
        function __construct($percorso, $contenuto = null) {
            $this->percorso = $percorso;
            if($this->contenuto==null && file_exists($percorso)) {
                $this->contenuto = file_get_contents($percorso);
            }
            else {
                $this->contenuto = $contenuto;
            }
        }
        
        /*
         * Elimina gli spazi, gli a capo e i commenti dal contenuto del file
         * 
         * Nota: questo metodo agisce sulla variabile di classe $contenuto, per rendere
         * effettive le modifiche il file andrà salvato con il metodo salva
         */
        function minimizzaContenuto() {
            $this->contenuto = str_replace(array("\r","\s","\n"), "", $this->contenuto);
            $this->contenuto = preg_replace('!/\*.*?\*/!s', '', $this->contenuto);
        }
        
        /*
         * Copia il contenuto di altri file all'interno della variabile contenuto
         * 
         * Prende in input un array con i percorsi dei file da importare 
         */
        function importaContenutoAltriFile($arrayFile) {
            foreach($arrayFile as $file) {
                $this->contenuto .= file_get_contents($file);
            }
        } 
        
        function salva() {
            $file = fopen($this->percorso, "w");
            fwrite($file,$this->contenuto);
            fclose($file);
        }
        
        function copia($nuovoPercorso) {
            copy($this->percorso,$nuovoPercorso);
        }
        
        function rinomina($nuovoNome) {
            rename($this->percorso,$nuovoNome);
        }
        
        function elimina() {
            unlink($this->percorso);
        }
        
        function getPercorso() {
            return $this->percorso;
        }

        function getContenuto() {
            return $this->contenuto;
        }

        function setPercorso($percorso) {
            $this->percorso = $percorso;
        }

        function setContenuto($contenuto) {
            $this->contenuto = $contenuto;
        }

    }